/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3612;
import net.minecraft.class_3962;
import net.minecraft.class_5250;
import net.minecraft.class_5556;
import net.minecraft.class_5712;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.compat.modmenu.ModMenuManager;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.items.LiquidEgg;
import wallywhip.resourcechickens.json.ChickenData;

public class NestTileEntity
extends class_2586
implements class_1263 {
    public final class_2371<class_1799> STORED_ITEMS = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    public ChickenData chickenData = null;
    public class_2487 entityCaptured = null;
    public class_2561 entityDescription = null;
    public class_5250 entityCustomName = null;
    public class_2960 chickenTexture = null;
    public int eggLayTime;
    public int chickenAge;
    public int chickenGrowth;
    public int chickenGain;
    public int chickenStrength;
    public int foodLevel = 0;
    public boolean analyzed = false;
    public boolean isWarm = false;

    public NestTileEntity(class_2338 blockPos, class_2680 blockState) {
        super(initTiles.NEST_BLOCK_TILE, blockPos, blockState);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        if (compound.method_10545("Items")) {
            compound.method_10562("Items").method_10569("Size", 6);
            this.STORED_ITEMS.clear();
            class_1262.method_5429((class_2487)compound, this.STORED_ITEMS);
        }
        if (compound.method_10545("foodLevel")) {
            this.foodLevel = compound.method_10550("foodLevel");
        }
        if (compound.method_10545("entityCaptured")) {
            this.entitySet(compound.method_10562("entityCaptured"), compound.method_10558("entityDescription"), false);
        } else {
            this.entityRemove(false);
        }
        if (compound.method_10545("isWarm")) {
            this.isWarm = compound.method_10577("isWarm");
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        class_1262.method_5427((class_2487)compound, this.STORED_ITEMS, (boolean)true);
        compound.method_10569("foodLevel", this.foodLevel);
        compound.method_10556("isWarm", this.isWarm);
        if (this.entityCaptured != null) {
            this.entityCaptured.method_10569("EggLayTime", this.eggLayTime);
            this.entityCaptured.method_10569("Age", this.chickenAge);
            compound.method_10566("entityCaptured", (class_2520)this.entityCaptured);
            compound.method_10582("entityDescription", this.entityDescription.getString());
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NestTileEntity tile) {
        boolean isDirty = false;
        class_1799 eggStack = (class_1799)tile.STORED_ITEMS.get(5);
        if (!eggStack.method_7960()) {
            ChickenData data;
            if (tile.entityCaptured == null && (data = eggStack.method_31574(initItems.EGG_DUCK) ? initChickenRegistry.DATA.get("duck") : initChickenRegistry.DATA.get("chicken")) != null) {
                class_2487 compound = new class_2487();
                compound.method_10582("id", class_1299.method_5890(data.entityType).toString());
                compound.method_10569("Age", -24000);
                tile.chickenAge = -24000;
                if (eggStack.method_7938()) {
                    class_2561 component = eggStack.method_7964();
                    compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)component));
                }
                tile.entitySet(compound, data.displayName.getString(), true);
            }
            if (!tile.isWarm) {
                return;
            }
            if (tile.chickenAge < 0) {
                ++tile.chickenAge;
                if (tile.chickenAge >= 0) {
                    class_1296 bird = (class_1296)tile.chickenData.entityType.method_5883(world);
                    if (bird != null) {
                        ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                        world.method_8396(null, pos, world.field_9229.method_43056() ? class_3417.field_15219 : (tile.chickenData.hasTrait == 1 ? initSounds.DUCK_AMBIENT : class_3417.field_14871), class_3419.field_15245, 1.0f, 1.0f);
                        bird.method_5651(tile.entityCaptured);
                        bird.method_23327((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
                        bird.method_7217(true);
                        world.method_8649((class_1297)bird);
                    }
                    tile.entityRemove(true);
                    tile.STORED_ITEMS.set(5, (Object)class_1799.field_8037);
                    return;
                }
                tile.method_5431();
                return;
            }
        }
        if (tile.entityCaptured == null) {
            return;
        }
        if (tile.chickenAge < 0) {
            ++tile.chickenAge;
            if (tile.chickenAge >= 0) {
                ((class_3218)world).method_14199((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.2, (double)pos.method_10260() + 0.5, 10, 0.3, 0.2, 0.3, 0.0);
                world.method_8396(null, pos, world.field_9229.method_43056() ? class_3417.field_15219 : (tile.chickenData.hasTrait == 1 ? initSounds.DUCK_AMBIENT : class_3417.field_14871), class_3419.field_15245, 1.0f, 1.0f);
                tile.eggLayTime = ResourceChickens.calcNewEggLayTime(world.field_9229, tile.chickenData, tile.chickenGrowth);
                tile.sendRenderUpdates();
                isDirty = true;
            }
        }
        if (tile.chickenData.eggLayTime != 0 && tile.chickenAge >= 0) {
            boolean isOK = true;
            if (ModMenuManager.getConfig().isSeededChamber().booleanValue()) {
                boolean bl = isOK = tile.foodLevel != 0;
            }
            if (isOK) {
                --tile.eggLayTime;
                if (tile.eggLayTime == 0) {
                    tile.eggLayTime = ResourceChickens.calcNewEggLayTime(world.field_9229, tile.chickenData, tile.chickenGrowth);
                    List<class_1799> DROPS = ResourceChickens.calcDrops(tile.chickenGain, tile.chickenData, 0);
                    if (DROPS.isEmpty()) {
                        return;
                    }
                    if (ModMenuManager.getConfig().isSeededChamber().booleanValue()) {
                        --tile.foodLevel;
                    }
                    isDirty = true;
                    class_2338 posBelow = pos.method_10074();
                    class_2680 downState = world.method_8320(posBelow);
                    boolean isCauldron = downState.method_26204() instanceof class_2275;
                    for (class_1799 itm : DROPS) {
                        class_1842 potion;
                        class_1792 class_17922 = itm.method_7909();
                        if (class_17922 instanceof LiquidEgg) {
                            class_2680 newState;
                            LiquidEgg le = (LiquidEgg)class_17922;
                            if (!isCauldron) continue;
                            if (le.fluidType == class_3612.field_15910) {
                                newState = (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3));
                                world.method_8501(posBelow, newState);
                                world.method_43276(class_5712.field_28733, posBelow, class_5712.class_7397.method_43287((class_2680)newState));
                                itm.method_7934(1);
                                continue;
                            }
                            if (le.fluidType != class_3612.field_15908) continue;
                            newState = class_2246.field_27098.method_9564();
                            world.method_8501(posBelow, newState);
                            world.method_43276(class_5712.field_28733, posBelow, class_5712.class_7397.method_43287((class_2680)newState));
                            itm.method_7934(1);
                            continue;
                        }
                        if (!itm.method_31574(class_1802.field_8574) || (potion = class_1844.method_8063((class_1799)itm)) != class_1847.field_8991 && potion != class_1847.field_8984 || !isCauldron) continue;
                        int f = (Integer)downState.method_11654((class_2769)class_5556.field_27206) + 1;
                        if (f < 4) {
                            class_2680 newState = (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(f));
                            world.method_8501(posBelow, newState);
                            world.method_43276(class_5712.field_28733, posBelow, class_5712.class_7397.method_43287((class_2680)newState));
                        }
                        itm.method_7934(1);
                    }
                    class_1263 outputINV = class_2614.method_11250((class_1937)world, (class_2338)pos.method_10074());
                    if (outputINV != null) {
                        for (int slot = 1; slot < 5; ++slot) {
                            tile.STORED_ITEMS.set(slot, (Object)class_2614.method_11260((class_1263)tile, (class_1263)outputINV, (class_1799)((class_1799)tile.STORED_ITEMS.get(slot)), null));
                        }
                        DROPS.replaceAll(stack -> class_2614.method_11260((class_1263)tile, (class_1263)outputINV, (class_1799)stack, null));
                    }
                    if (downState.method_27852(class_2246.field_17563) && !world.field_9236) {
                        int a;
                        class_2680 oldState = downState;
                        block2: for (class_1799 stack2 : tile.STORED_ITEMS) {
                            int COUNT = stack2.method_7947();
                            for (a = 0; a < COUNT; ++a) {
                                if ((Integer)oldState.method_11654((class_2769)class_3962.field_17565) == 7) break block2;
                                class_2680 returnState = class_3962.method_26373((class_1297)null, (class_2680)oldState, (class_3218)((class_3218)world), (class_1799)stack2, (class_2338)posBelow);
                                world.method_20290(1500, posBelow, returnState != oldState ? 1 : 0);
                                oldState = returnState;
                            }
                        }
                        block4: for (class_1799 stack3 : DROPS) {
                            int COUNT = stack3.method_7947();
                            for (a = 0; a < COUNT; ++a) {
                                if ((Integer)oldState.method_11654((class_2769)class_3962.field_17565) == 7) break block4;
                                class_2680 returnState = class_3962.method_26373((class_1297)null, (class_2680)oldState, (class_3218)((class_3218)world), (class_1799)stack3, (class_2338)posBelow);
                                world.method_20290(1500, posBelow, returnState != oldState ? 1 : 0);
                                oldState = returnState;
                            }
                        }
                    }
                    DROPS.forEach(tile::insertItemAnySlot);
                    if (!DROPS.isEmpty() && ModMenuManager.getConfig().isAllowInWorldDrops().booleanValue()) {
                        DROPS.forEach(stack -> class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack));
                    }
                    tile.sendRenderUpdates();
                }
            }
        }
        if (isDirty) {
            tile.method_5431();
        }
    }

    public void entityRemove(boolean sendUpdates) {
        this.chickenGrowth = 0;
        this.chickenGain = 0;
        this.chickenStrength = 0;
        this.analyzed = false;
        this.chickenAge = 0;
        this.eggLayTime = 0;
        this.chickenData = null;
        this.entityCaptured = null;
        this.entityDescription = null;
        this.entityCustomName = null;
        this.STORED_ITEMS.set(5, (Object)class_1799.field_8037);
        this.method_5431();
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
    }

    public void entitySet(class_2487 compound, String desc, boolean sendUpdates) {
        class_5250 name;
        this.entityCaptured = compound.method_10553();
        this.entityDescription = class_2561.method_43470((String)desc);
        this.chickenData = initChickenRegistry.getChickenDataFromEntityID(this.entityCaptured.method_10558("id"));
        if (((class_1799)this.STORED_ITEMS.get(5)).method_7960()) {
            this.chickenTexture = ResourceChickens.getTexture(this.chickenData, compound.method_25926("UUID"));
        }
        if (compound.method_10545("CustomName") && (name = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"))) != null) {
            this.entityCustomName = name.method_27692(class_124.field_1056);
        }
        this.eggLayTime = compound.method_10550("EggLayTime");
        this.chickenAge = compound.method_10550("Age");
        this.chickenGrowth = compound.method_10550("growth");
        this.chickenGain = compound.method_10550("gain");
        this.chickenStrength = compound.method_10550("strength");
        this.analyzed = compound.method_10577("analyzed");
        this.method_5431();
        if (sendUpdates) {
            this.sendRenderUpdates();
        }
    }

    public void sendRenderUpdates() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void entitySetCustomName(class_2487 compound) {
        if (this.entityCaptured != null) {
            if (compound != null && compound.method_10573("Name", 8)) {
                try {
                    String name = compound.method_10558("Name");
                    class_5250 text = class_2561.class_2562.method_10877((String)name);
                    if (text != null) {
                        this.entityCaptured.method_10582("CustomName", name);
                        this.entityCustomName = text.method_27692(class_124.field_1056);
                        this.method_5431();
                        return;
                    }
                }
                catch (JsonParseException e) {
                    compound.method_10551("Name");
                }
            }
            this.entityCaptured.method_10551("CustomName");
            this.entityCustomName = null;
            this.method_5431();
        }
    }

    public int method_5439() {
        return this.STORED_ITEMS.size();
    }

    public boolean method_5442() {
        return this.STORED_ITEMS.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.STORED_ITEMS.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot == 0) {
            return class_1799.field_8037;
        }
        if (slot == 5) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = class_1262.method_5430(this.STORED_ITEMS, (int)slot, (int)amount);
        if (ModMenuManager.getConfig().isNestRenderItems().booleanValue()) {
            this.sendRenderUpdates();
        }
        return itemStack;
    }

    public class_1799 method_5441(int slot) {
        if (slot == 0) {
            return class_1799.field_8037;
        }
        if (slot == 5) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = class_1262.method_5428(this.STORED_ITEMS, (int)slot);
        if (ModMenuManager.getConfig().isNestRenderItems().booleanValue()) {
            this.sendRenderUpdates();
        }
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot == 0 && !stack.method_7960()) {
            int limit = 100 - this.foodLevel;
            if (limit <= 0) {
                return;
            }
            int amountToCopy = Integer.min(limit, stack.method_7947());
            stack.method_7934(amountToCopy);
            this.foodLevel += amountToCopy;
            this.sendRenderUpdates();
            return;
        }
        this.STORED_ITEMS.set(slot, (Object)stack);
        if (ModMenuManager.getConfig().isNestRenderItems().booleanValue()) {
            this.sendRenderUpdates();
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.STORED_ITEMS.clear();
        if (ModMenuManager.getConfig().isNestRenderItems().booleanValue()) {
            this.sendRenderUpdates();
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot == 0) {
            if (this.chickenData != null) {
                if (this.chickenData.feedItem.isEmpty()) {
                    return stack.method_31573(ResourceChickenEntity.CHICKEN_FEED);
                }
                return stack.method_31574(this.chickenData.feedItemItem);
            }
            return stack.method_31573(ResourceChickenEntity.CHICKEN_FEED);
        }
        if (slot == 5) {
            return stack.method_31574(class_1802.field_8803) || stack.method_31574(initItems.EGG_DUCK);
        }
        return false;
    }

    private void insertItemAnySlot(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        if (!stack.method_7946()) {
            for (int slot = 1; slot < 5; ++slot) {
                class_1799 existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (!existing.method_7960()) continue;
                this.method_5447(slot, stack);
                return;
            }
        } else {
            class_1799 existing;
            int slot;
            for (slot = 1; slot < 5; ++slot) {
                int freeSpace;
                existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (existing.method_7909() != stack.method_7909() || (freeSpace = existing.method_7914() - existing.method_7947()) <= 0) continue;
                int toInsert = Integer.min(freeSpace, stack.method_7947());
                existing.method_7933(toInsert);
                stack.method_7934(toInsert);
                if (stack.method_7947() != 0) continue;
                return;
            }
            for (slot = 1; slot < 5; ++slot) {
                existing = (class_1799)this.STORED_ITEMS.get(slot);
                if (!existing.method_7960()) continue;
                this.method_5447(slot, stack);
                return;
            }
        }
    }

    public boolean addToExistingSlot(class_1799 stack, int slot, boolean isCreative) {
        if (slot == 0) {
            int limit = 100 - this.foodLevel;
            if (limit <= 0) {
                return false;
            }
            int amountToCopy = Integer.min(limit, stack.method_7947());
            if (!isCreative) {
                stack.method_7934(amountToCopy);
            }
            this.foodLevel += amountToCopy;
            this.sendRenderUpdates();
            return true;
        }
        class_1799 itemStack = (class_1799)this.STORED_ITEMS.get(slot);
        if (itemStack.method_7960()) {
            this.method_5447(slot, stack.method_7972());
            if (!isCreative) {
                stack.method_7934(((class_1799)this.STORED_ITEMS.get(slot)).method_7947());
            }
            return true;
        }
        if (this.canCombine(itemStack, stack)) {
            int i = Math.min(this.method_5444(), itemStack.method_7914());
            int j = Math.min(stack.method_7947(), i - itemStack.method_7947());
            if (j > 0) {
                itemStack.method_7933(j);
                if (!isCreative) {
                    stack.method_7934(j);
                }
                return true;
            }
        }
        return false;
    }

    private boolean canCombine(class_1799 one, class_1799 two) {
        return class_1799.method_31577((class_1799)one, (class_1799)two);
    }
}

